function[s0,x0,alpha,npeak]=peakpick ( ss, xx )
%fits a vertical parabola through 3 peakpoints
N=length(ss);
if N < 5
    ERROR('niet genoeg punten om piek te meten');
end
if nargin < 2
    xx= 0:N-1;
end
smax=max(ss);
smin=smax*0.125;


npeak=0;
n=3;
while n <= N-2
    if ( (ss(n-2)<=ss(n-1))&&(ss(n-1)<ss(n))&&(ss(n)>=ss(n+1))&&(ss(n+1)>ss(n+2))...
            && (ss(n)>smin)) ||...
            ((ss(n)<=smin)&&(ss(n-1)<ss(n))&& (ss(n)>=ss(n+1)) && (1.e-4*smax < ss(n)))
        npeak=npeak+1;
        ds21=ss(n)-ss(n-1);
        ds32=ss(n+1)-ss(n);
        dx21=xx(n)-xx(n-1);
        dx32=xx(n+1)-xx(n);
        sx21=xx(n)+xx(n-1);
        sx32=xx(n+1)+xx(n);
        rdx =dx21/dx32;
        if ds32 > 0
            rds =ds21/ds32;
            x0(npeak)=(sx21*rdx-sx32*rds)/(2*(rdx-rds));
        else
            x0(npeak)=(xx(n)+xx(n+1))/2;
        end
        a=-ds21/(dx21*(sx21-2*x0(npeak)));
        alpha(npeak)=a;
        s0(npeak)=ss(n)+a*(xx(n)-x0(npeak))^2;
%        n=n+1;
    end
    n=n+1;
end


if npeak > 3 && npeak < 40
    x00=x0; s00=s0;
    ip=2;
    while ip <= npeak-2
        if s0(ip) > smin
            dsdxp=(s0(ip+1)-s0(ip-1))/(x0(ip+1)-x0(ip-1));
            diff =dsdxp/(2*alpha(ip));
            x00(ip)=x0(ip)-diff;
            s00(ip)=s0(ip)-diff*diff;
        end
        ip=ip+1;
    end
    x0=x00; s0=s00;
end

